<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SpecialNumber extends Model 
{

    protected $table = 'special_numbers';
    public $timestamps = true;
    protected $fillable = array('id', 'number', 'special_number_category_id', 'selling_special_number_id', 'availabilty', 'active', 'size', 'transition_type', 'include_insurance', 'price', 'user_id');

    public function users()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function selling_special_number()
    {
        return $this->belongsTo('App\Models\SellingSpecialNumber');
    }

    public function special_number_reservations()
    {
        return $this->hasMany('App\Models\SpecialNumberReservation');
    }

    public function special_number_category()
    {
        return $this->belongsTo('App\Models\SpecialNumberCategory');
    }

    public function user_verifications()
    {
        return $this->belongsToMany('App\Models\User', 'special_numbers_verifications');
    }

    public function admins_verfication()
    {
        return $this->belongsToMany('App\Models\Admin', 'special_numbers_verifications');
    }

}